from pyod.models.iforest import IForest
from pyod.models.lof import LOF
from pyod.models.ocsvm import OCSVM
from pyod.models.knn import KNN
from pyod.models.hbos import HBOS
from pyod.models.abod import ABOD
from pyod.models.loda import LODA
from pyod.models.cof import COF
import numpy as np

clf_config = {
    ABOD: {
        'contamination': np.arange(0.09, 0.1, 0.001),
        'n_neighbors': range(5, 100),
        'method': ['fast', 'default']
    },

    COF: {
        'contamination': np.arange(0.09, 0.1, 0.001),
        'n_neighbors': [5, 10, 15, 20, 25, 30, 40, 50, 60, 70, 80, 90, 100]},

    HBOS: {
        'alpha': [0.1, 0.2, 0.3, 0.4, 0.5],
        'contamination': np.arange(0.09, 0.1, 0.001),
        'n_bins': np.arange(5, 40, 5),
        'tol': np.arange(0.05, 1.00, 0.05)},
    IForest: {
        'contamination': np.arange(0.09, 0.1, 0.001),
        'max_features': np.arange(0.05, 1.01, 0.05),
        'n_estimators': [25, 50, 100, 200],
    },
    KNN: {
        'contamination': np.arange(0.09, 0.1, 0.001),
        'algorithm': ['auto'],
        'leaf_size': range(1, 100),
        'method': ['largest', 'mean', 'median'],
        'metric': ['minkowski', 'manhattan', 'euclidean'],
        'n_neighbors': range(5, 100),
        'radius': np.arange(0.05, 1.01, 0.05)},

    LODA: {
        'contamination': np.arange(0.09, 0.1, 0.001),
        'n_random_cuts': np.arange(10, 200, 10),
        'n_bins': np.arange(5, 40, 5)},

    OCSVM: {
        'contamination': np.arange(0.09, 0.1, 0.001),
        'degree': range(1, 10),
        'gamma': ['auto'],
        'kernel': ['linear', 'poly', 'rbf', 'sigmoid'],
        'nu': np.arange(0.05, 1.01, 0.05),
        'tol': np.arange(0, 0.05, 0.001)}
}
